package furny.ga.operators;

import furny.entities.Furniture;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.GA;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

/**
 * This crossover operator swaps furnitures between two individuals.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SwapCrossoverOp extends ProbabilityOp implements
    ICrossoverOp<FurnLayoutIndividual> {
  // TODO swap probability pSwap

  /**
   * Creates the operator with a given crossover probability.
   * 
   * @param pCrossOver
   *          Crossover probability.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SwapCrossoverOp(final int pCrossOver) {
    super(pCrossOver);
  }

  @Override
  public IndividualList<FurnLayoutIndividual> crossover(
      final FurnLayoutIndividual individual1,
      final FurnLayoutIndividual individual2, final GAContext context) {
    final IndividualList<FurnLayoutIndividual> list = new IndividualList<FurnLayoutIndividual>();
    final FurnLayoutIndividual ind1 = individual1.clone();
    final FurnLayoutIndividual ind2 = individual2.clone();

    if (doOperate()) {
      FurnEntryList smaller;
      FurnEntryList bigger;
      if (ind1.getFurnitures().size() < ind2.getFurnitures().size()) {
        smaller = ind1.getFurnitures();
        bigger = ind2.getFurnitures();
      } else {
        smaller = ind2.getFurnitures();
        bigger = ind1.getFurnitures();
      }

      int i = 0;

      while (i++ < bigger.size()) {
        final boolean swap = getRandom().nextBoolean();

        if (swap) {
          if (i < smaller.size()) {
            final boolean keepPosition = getRandom().nextBoolean();

            if (keepPosition) {
              // swap the furnitures, keep the positions
              final FurnEntry entry1 = smaller.get(i);
              final FurnEntry entry2 = bigger.get(i);

              final Furniture fTemp = entry1.getFurniture();
              entry1.setFurniture(entry2.getFurniture());
              entry2.setFurniture(fTemp);
            } else {
              smaller.set(i, bigger.set(i, smaller.get(i)));
            }

          } else {
            smaller.add(bigger.remove(getRandom().nextInt(bigger.size())));
          }
        }
      }
    }

    list.add(ind1);
    list.add(ind2);

    return list;
  }

  /**
   * Main method for testing.
   * 
   * @param args
   *          No arguments required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void main(final String[] args) {
    final GAContext context = new GAContext();
    context.put(GA.KEY_VALIDATION_SPACE, new PseudoSpace(10f, 10f));

    final FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
    ind1.initRandomly();

    final FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
    ind2.initRandomly();
    ind2.getFurnitures().add(ind1.getFurnitures().get(0));

    final ICrossoverOp<FurnLayoutIndividual> crossover = new SwapCrossoverOp(
        100);

    System.out.println("\n PARENT 1\n");
    System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind1
        .getSimpleGenotype()));

    System.out.println("\n PARENT 2\n");
    System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind2
        .getSimpleGenotype()));

    final IndividualList<FurnLayoutIndividual> list = crossover.crossover(ind1,
        ind2, context);

    for (int i = 0; i < list.size(); i++) {
      final FurnLayoutIndividual newInd = list.get(i);

      System.out.println("\n CHILD " + (i + 1) + "\n");
      System.out.println(FurnLayoutIOUtil.printSimpleGenotype(newInd
          .getSimpleGenotype()));
    }
  }
}
